<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class PannelloLaterale {
        private $db;
        private $pannello ;
        
        function __construct($db, $pannello ="") {
            $this->db   = $db;
            $this->pannello  = $pannello ;
        }
        
        function aggiungiComponente($idComponente,$nomeDaMostrare) {
            $queryPosizione = "SELECT * FROM  geecB_composizionePannelloLaterale  WHERE nomePannello LIKE '$this->pannello' ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geecB_composizionePannelloLaterale` (`id`, `idComponente`, `idElemento`, `nomePannello`, `testo`, `posizione`, `nomeDaMostrare`) "
                    . "VALUES (NULL, '$idComponente', '0', '$this->pannello', '', '$posizione', '$nomeDaMostrare');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modificaComponente($id, $idElemento, $nomeDaMostrare, $testo) {
            $query = "UPDATE  geecB_composizionePannelloLaterale  SET idElemento='$idElemento', nomeDaMostrare='$nomeDaMostrare',testo='$testo' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaComponente($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM  geecB_composizionePannelloLaterale  WHERE nomePannello LIKE '$this->pannello' AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE  geecB_composizionePannelloLaterale SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE  geecB_composizionePannelloLaterale  SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaComponente($idElemento) {
            $this->db->eseguiQueryCancellazione(" geecB_composizionePannelloLaterale ",$idElemento);
        }
        
        function stampaElencoComponenti() {
            $query          = "SELECT cpl.*, c.nome FROM geecB_composizionePannelloLaterale AS cpl JOIN geecB_componenti AS c ON cpl.idComponente = c.id WHERE cpl.nomePannello LIKE '$this->pannello' ORDER BY posizione ASC";
            $risComponenti  = $this->db->eseguiQueryLettura($query);
            
            while($componente = $risComponenti->fetch_assoc()) {
                $posizionePrecedente  = ($componente["posizione"]<=1) ? 1 : $componente["posizione"] - 1;
                $posizioneSuccesiva   = $componente["posizione"] +1;
                $nomeDaMostrareEscape = filter_var($componente["nomeDaMostrare"],FILTER_SANITIZE_ADD_SLASHES);

                echo"<div id=\"componentePannello{$componente["id"]}\" class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$componente["nomeDaMostrare"]}</strong></em>  </p>
                            <small><em>{$componente["nome"]}</em>  </small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <form class=\"d-inline-flex mr-sm-1\">
                                <div class=\"input-group input-group-sm d-flex align-items-center\">
                                    <small class=\"text-muted mr-2\">Pos.</small>
                                    <input type=\"number\" id=\"nuovaPosizioneComponentePannello{$componente["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$componente["posizione"]}\">
                                    <div class=\"input-group-append\">
                                        <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaComponentePannelloInput('../',{$componente["id"]},'$this->pannello')\">Salva</button>
                                    </div>
                                </div>
                            </form>
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaComponentePannello('../',{$componente["id"]},$posizionePrecedente,'$this->pannello')\"><i class=\"fas fa-arrow-up\" ></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaComponentePannello('../',{$componente["id"]},$posizioneSuccesiva,'$this->pannello')\"><i class=\"fas fa-arrow-down\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\"data-toggle=\"modal\" data-target=\"#configuraComponente{$componente["id"]}\" data-placement=\"bottom\" title=\"Configura componente\"><i class=\"fas fa-cog\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"apriPopupEliminaComponentePannello({$componente["id"]},'$nomeDaMostrareEscape','{$componente["nome"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>";
            }
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getNome() {
            return $this->pannello ;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setNome($pannello ) {
            $this->pannello  = $pannello ;
        }
    }